<?php
// Set headers for API response
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Include database connection
include_once 'db.php';

// Define user_id (Static value as per request)
$user_id = 4;

try {
    // Prepare SQL query to fetch user bank details
    $sql = "SELECT acount_name, acount_no, ifsc, bank_name, acount_type, upiid 
            FROM user_profile 
            WHERE User_id = $user_id 
            LIMIT 1";

    $result = mysqli_query($conn, $sql);

    if (!$result) {
        throw new Exception("Query failed: " . mysqli_error($conn));
    }

    // Fetch user data
    $user_data = mysqli_fetch_assoc($result);

    if (!$user_data) {
        echo json_encode(["status" => "error", "message" => "No data found for user_id $user_id"]);
    } else {
        echo json_encode(["status" => "success", "data" => $user_data]);
    }

} catch (Exception $e) {
    // Handle any errors
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}

// Close the database connection
mysqli_close($conn);
?>
